import java.io.*;

public class Kopiuj {
  public static void main (String args[]) {
    if(args.length < 2){
      System.out.println("Wywoanie programu: Kopiuj plik_rdowy plik_docelowy");
      return;
    }

    File sourceFile = new File(args[0]);
    File destFile = new File(args[1]);

    if(!sourceFile.exists()){
      System.out.println("Plik rdowy nie istnieje.");
      return;
    }
    if(destFile.exists()){
      System.out.print("Plik docelowy istnieje. Czy mam go usun? [t/n]:");
      
      BufferedReader brIn = new BufferedReader(
        new InputStreamReader(System.in)
      );
      String line = "";
      try{
        line = brIn.readLine();
      }
      catch(IOException e){
        System.out.println("Bd podczas odczytu strumienia.");
        return;
      }
      if(!"t".equals(line))
        return;
      if(!destFile.delete()){
        System.out.println("Nie mog usun pliku.");
        return;
      }
    }
    RandomAccessFile rafSource = null;
    RandomAccessFile rafDest = null;

    try{
      rafSource = new RandomAccessFile(sourceFile, "r");
      rafDest = new RandomAccessFile(destFile, "rw");
    }
    catch(FileNotFoundException e){
      System.out.println("Bd podczas otwierania plikw: " + e);
      return;
    }

    int count = 0;
    int buffSize = 10000;
    byte[] buff = new byte[buffSize];

    try{
      while((count = rafSource.read(buff)) != -1){
        rafDest.write(buff, 0, count);
      }
      rafDest.close();
      rafSource.close();
    }
    catch(IOException e){
      System.out.print("\nBd wejcia-wyjcia podczas kopiowania pliku.");
      return;
    }
  }
}
